 ; Ŀ
 ;   Acad2.lsp - secondary lisp load/configuration file.                   
 ;   Copyright 1993-2010 by Rocket Software Ltd.                           
 ;   Updated for Acad 2005 - 2010.                                         
 ;   Rocket: Software that works, for people who'd rather not.             
 ; 

 ; Ŀ
 ;   Loading your own files:                                               
 ;   Files placed in the directory \Rocket\Lisp\Load are automatically     
 ;   loaded.                                                               
 ;   Programs can also be added to the file Local.lsp using the format     
 ;   (rload "filename" '("lispname"))                                      
 ;                                                                         
 ;   Local.lsp loads files more quickly, the Load directory is easier      
 ;   for files which are only going to be used temporarily.                
 ;                                                                         
 ;   If you modify this file (acad2.lsp) and it is replaced with a newer   
 ;   version then you will have to copy your changes to the new file, so   
 ;   the previous two methods are preferable.                              
 ; 

 ; Ŀ
 ;   Timers: load and then initialize.                                     
 ;   These pretty well have to be at the beginning.                        
 ; 
 (DEFUN ST1 ()
  (setq s (getvar "date"))
  (setq t1 (* 86400.0 (- s (fix s))))
 (princ))

 (DEFUN CT1 ()
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (write-line (setq te (strcat "\nRocket load time: "
                                (rtos (- t2 t1) 2 1) " seconds.")))
 (princ))

(st1)                                ; start the timer
 ; Ŀ
 ;   Timers end.                                                           
 ; 

 ; Ŀ
 ;   Lawn - load, check, and optionally run a lisp file.                   
 ;   Arguments: Name - The routine to load.                                
 ;              Run  - Run the routine if this isn't nil.                  
 ; 
 (DEFUN LAWN (name run)
  (if (load name ())
      (if run (eval (read (strcat "(c:" name ")"))))
      (write-line (strcat "** Can't load " name ". **\n")))
 (princ))
 ; Ŀ
 ;   Lawn end.  (Typically the sidewalk.)                                  
 ; 

 ; Ŀ
 ;   Rationalise a few system settings.                                    
 ;                                                                         
 ;   Settings which affect the way the user works without changing the     
 ;   finished drawing, and which are not stored in the drawing, are        
 ;   probably best set up on each machine.                                 
 ;   Sysvars which affect the output or which are stored in each           
 ;   drawing should be set up here, the only exception being those which   
 ;   may differ between jobs - for instance most clients use an Ltscale    
 ;   of 10 x Dimscale, some are as far off as 6, and at least one          
 ;   company has made their own linetypes and sets Ltscale equal to        
 ;   dimscale.                                                             
 ;                                                                         
 ;   One could place an individual configuration file in each job          
 ;   directory, or a section here which ties program behaviour to the      
 ;   job based on the presence of a known logo or title block, but         
 ;   this type of thing requires both a certain amount of customization    
 ;   and information about the jobs being done - in other words it is      
 ;   easy to do but impossible to do as a general solution.                
 ;   The programs Halo.lsp and Datt.lsp would be a good starting point.    
 ; 
(setvar "aflags" 0)           ; make new attributes not ivcp or position locked
(setvar "auprec" 2)           ; display angles to two decimal places
(setvar "attdia" 0)           ; don't use dd box to get attribute values
(setvar "attreq" 1)           ; prompt for attribute values on block insertion
(setvar "cecolor" "bylayer")  ; set entity creation colour to bylayer
(setvar "celtype" "bylayer")  ; set entity creation linetype to bylayer
(setvar "celtscale" 1)        ; set entity creation linetype scale to 1
(setvar "chamfera" 0)         ; chamfer distance
(setvar "chamferb" 0)         ; chamfer distance
(setvar "chamferc" 0)         ; chamfer distance
(setvar "chamferd" 0)         ; chamfer distance
(setvar "cmddia" 1)           ; use dd box for commands where appropriate
(setvar "coords" 2)           ; set coords to dist<angle where appropriate
(if (getvar "dimassoc")
    (setvar "dimassoc" 2))    ; make real associative dimensions (2002+)
;(setvar "dogmode" 1)         ; use canis domesticus as default animal
 ; Ŀ
 ;   If Dimanno (2008+) is set to 1 then Dimscale is forced to 0 and       
 ;   trying to change it will crash a lisp routine.                        
 ;   Otherwise dimscale shouldn't be 0.                                    
 ; 
(if (and (or (null (getvar "dimanno"))
             (/= 1 (getvar "dimanno")))
         (= (getvar "dimscale") 0))
    (setvar "dimscale" 1))
(if (/= (getvar "elevation") 0)
    (progn
         (setvar "elevation" 0)
         (prompt "*** Drawing elevation set to 0 ***\n")))
(setvar "filedia" 1)          ; use dd box for file selection
(setvar "fillmode" 1)         ; display/plot solids filled
(if (getvar "griddisplay")
    (setvar "griddisplay" 0)) ; strange adaptive grid display
(setvar "gridmode" 0)         ; turn grid off
 ; Ŀ
 ;   Indexctl turns on Spatial and Layer indexes - these are saved with    
 ;   drawing files and speed up xref use by making it easier for acad      
 ;   to find the parts of the file to display.  For this to work you       
 ;   should also set Xloadctl to 2, which sets Demand Load Xrefs to        
 ;   "Enabled with Copy."  Anything else is, as bitter experience tells    
 ;   us, bad.                                                              
 ;   Note that this makes files slightly larger and presumably slows       
 ;   down non-xref files a bit, but typically this isn't a problem.        
 ; 
(setvar "indexctl" 3)
(setvar "insunits" 0)         ; unitless insertion - don't auto scale blocks
(setvar "limcheck" 0)         ; turn limits checking off
;(setvar "ltscale" (* 10 (getvar "dimscale")))  ; linetype scale
(setvar "luprec" 4)           ; display lengths to two decimal places
(setvar "maxsort" 500)        ; maximum list length to sort
 ; Ŀ
 ;   MButtonPan can be 1: regardless of the command in the menu file,      
 ;   the middle button is the pan command, or 0, do what it says in the    
 ;   file.  One might ask why if one wants the middle button to be pan     
 ;   one doesn't just put pan in the menu file, or why the pan command     
 ;   has gone from being simple and useful to having dozens of settings    
 ;   and (perhaps poorly conceived) options...                             
 ; 
;(setvar "mbuttonpan" 0)      ; don't use the middle button to pan
 ; Ŀ
 ;   If measurement is set to 0 then hatches and linetypes will be drawn   
 ;   using the Imperial definitions in the Ansi files, if 1 then it uses   
 ;   the Iso metric definitions.  For the preset hatch commands to work    
 ;   properly this should be set to 0.                                     
 ; 
(setvar "measurement" 0)      ; use imperial for hatch patterns and linetypes
(setvar "menuecho" 0)         ; sets menu echo to OFF
(setvar "mirrtext" 0)         ; straight copy text with mirror command
(setvar "offsetgaptype" 1)    ; round corners off on offsets
;(setvar "osmode" 0)          ; turn off running osnaps
(setvar "pdmode" 0)           ; make points display as points
 ; Ŀ
 ;   Pickstyle: this controls which related entities are selected along    
 ;   with one you picked.                                                  
 ;   0 = Off.                                                              
 ;   1 = Select anything in groups the entity is part of.                  
 ;   2 = If the entity is an associative hatch, select its boundary        
 ;       entities.                                                         
 ;   3 = both 1 and 2.                                                     
 ; 
(setvar "pickstyle" 1)        ; allow group selection
(setvar "plinegen" 0)         ; sets pline generation to non-continuous
(setvar "plinewid" 0)         ; set default polyline width to 0
(setvar "regenmode" 1)        ; sets regen auto on
(setvar "savetime" 10)        ; autosave time set to ten minutes
 ; Ŀ
 ;   Visual effects stuff.  Cool until irritating time = ten seconds.      
 ; 
(if (getvar "selectionpreview")
    (progn
         (setvar "selectionpreview" 0)  ; highlight stuff the cursor comes near
         (setvar "vtenable" 0)))        ; waste time by zooming slowly
 ; Ŀ
 ;   If Shortcutmenu is set to zero then the first line in the Aux or      
 ;   Buttons menu is used as is, otherwise the appropriate shortcut menu   
 ;   is pulled up.  This is bit coded - there are several possibilities.   
 ;   This seems inelegant...                                               
 ; 
;(setvar "shortcutmenu" 0)    ; use first line in buttons/aux menu
(if (not (equal (getvar "snapbase") '(0 0)))
    (prompt "*** Warning: Snapbase is not 0,0. ***\n"))
(setvar "snapmode" 1)         ; sets snap on
(setvar "visretain" 1)        ; retain xref layer/lt settings in drawing
(setvar "wmfbkgnd" 0)         ; transparent wmf background
(setvar "wmfforegnd" 0)       ; wmf foreground darker than background
(setvar "xclipframe" 0)       ; turn off xclip frames
(setvar "xloadctl" 2)      ; Demand Load Xrefs: Enabled with Copy. See Indexctl
 ; Ŀ
 ;   Other sysvars to consider presetting:                                 
 ; 
 ; Plinetype:   0 = use old style polylines
 ;              1 = create new style polylines (lwpolylines)
 ;              2 = create and convert old style polylines on drawing open
 ; Proxynotice: 0 = don't display the proxy entities warning.
 ; Maxhatch:    Maximum number of elements in a hatch.  (This is a system
 ;              variable, not a setvar.  Details in the manual.)
 ; Maxactvp:    Maximum vports which will display contents at one time
 ; Plquiet:     0 = don't warn about missing plot setting files, 1 = do.
 ;              This may fix the intermittent Ploto crash.
 ;              It may (?) be automatically set while a script file is active.
 ; Ŀ
 ;   System settings end.                                                  
 ; 

 ; Ŀ
 ;   Load and optionally run lisps.                                        
 ; 
 ; Ŀ
 ;   Run Blup to update any files named in the Blup Xrecord entity or in   
 ;   the external data file BlockUpdate.txt.                               
 ;   This only works if the block is available in the search path.         
 ; 
(lawn "blup" t)                  ; see Pulp - add a block to the xrecord
 ; Ŀ
 ;   Load Clime to load files and climb the directory tree if necessary    
 ;   to find them.                                                         
 ; 
(lawn "clime" ())
 ; Ŀ
 ;   Load Cope to copy files from the network if the date stamp file on    
 ;   L: is later than the one on C:.                                       
 ;   This must be set up for the network structure being used.             
 ; 
;(lawn "cope" t)
 ; Ŀ
 ;   Update the drawing name, user and date block Qdatt if it is present.  
 ; 
(lawn "datt" t)
 ; Ŀ
 ;   Load and run Dill: load files found in \Rocket\Lisp\Load.             
 ; 
(lawn "dill" t)
 ; Ŀ
 ;   Make sure that there are no fixed height text styles.                 
 ; 
(lawn "fhk" t)
 ; Ŀ
 ;   Run Halo to update the tb data if possible.                           
 ; 
(lawn "halo" t)                  ; looks for the Jobno.txt file
 ; Ŀ
 ;   Run Halon, the more easily configured routine which can update any    
 ;   block based on the external data file Jobdata.txt.                    
 ;   Instructions are located in the file Halon.lsp.                       
 ; 
(lawn "halon" t)                 ; looks for the Jobdata.txt file
 ; Ŀ
 ;   Layer filters are an interesting idea.  Latte will kill them.         
 ; 
(lawn "latte" t)
 ; Ŀ
 ;   Set up Modemacro to display information on the status line.           
 ; 
(lawn "mac" t)
 ; Ŀ
 ;   Load the drawing history tracker, run the dwg names file updater.     
 ;   (Pike is part of Piranha, which must be loaded first.)                
 ; 
(lawn "piranha" ())              ; load but don't run
(if c:pike (c:pike))             ; run the history file updater
 ; Ŀ
 ;   Refa updates certain blocks based on a csv file, it also clinmbs      
 ;   the directory tree to find it.                                        
 ; 
;(lawn "refa" t)
 ; Ŀ
 ;   Rload preloads lisp files to allow them to be loaded as required      
 ;   without wasting an inordinate amount of time.                         
 ;   Loading rload turns off load logging, loading rloadt turns it on.     
 ;   The routine used is in either case Rload.                             
 ; 
(lawn "rload" ())                ; load but don't update trend.txt
;(lawn "rloadt" ())              ; load and log
 ; Ŀ
 ;   Warn of off/frozen/locked layers.                                     
 ; 
(lawn "schlock" t)               ; warn of off/frozen/locked layers
 ; Ŀ
 ;   Set up the Standard dimension style.  Currently not auto-run.         
 ; 
(lawn "stan" ())
 ; Ŀ
 ;   End of setup routines.                                                
 ; 

 ; Ŀ
 ;   Files which will probably be used are loaded outright with Lawn.      
 ; 
(lawn "ld" ())                   ; lisp loader.  see also xx
(lawn "lv" ())                   ; common command shortcut and snap control
(lawn "malaya" ())               ; layer setup: install/update/make current
(lawn "ten" ())                  ; get insertion for att. only block
 ; Ŀ
 ;   Block inserters and line breakers.                                    
 ; 
(lawn "catsup" ())               ; line breaker, repos. & rot. attributes
(lawn "ccut" ())                 ; multiple line breaker
(lawn "chop" ())                 ; line breaker
(lawn "devi" ())                 ; open/closed switch inserter
(lawn "instag" ())               ; instrument tag installer
 ; Ŀ
 ;   Rload stuff - fully load only when used.                              
 ;   First the remaining block inserters.                                  
 ; 
(rload "cutup" '("cutup"))       ; upright block insert, line break
(rload "online" '("online"))     ; upright block insert, no line break
(rload "termi" '("termi"))       ; terminal block on line, repos. atts p?
(rload "vcut" '("vcut"))         ; upright block insert, vertical line break
 ; Ŀ
 ;   Some graphic geometry routines.                                       
 ; 
(rload "cspi"    '("cspi"))      ; temp. graphics - star multi counterspiral
(rload "spi"     '("spi"))       ;                - star spiral
(rload "sta"     '("sta"))       ;                - star circlet
(rload "poxx"    '("poxx"))      ;                - spiral box
 ; Ŀ
 ;   And other useful stuff.                                               
 ;   Each routine included with Rocketcad is listed below, with a brief    
 ;   description.  A few are commented out, if you wish to preload one     
 ;   then remove the semicolon from the beginning of that line.            
 ; 
(rload "~"       '("~"))         ; line break symbol installer
(rload "19"      '("19"))        ; pipe break installer
(rload "300"     '("300"))       ; search and replace text in blocks
(rload "90"  '("45" "90" "180")) ; rotate entities by that amount
(rload "99"      '("99"))        ; plot from data in the block 99
(rload "3t"      '("3t"))        ; make a stack of text into one line
(rload "abc"     '("abc"))       ; alphabetise text vertically
(rload "abg"     '("abg"))       ; renumber text in sets with suffixes
(rload "above"  '("above" "nd")) ; add text above/below an existing entity
(rload "ac"      '("ac" "acc" "ack" "sac")) ; copy att vals from block to block
(rload "acla"    '("acla"))      ; area class generator
(rload "adat"    '("adat"))      ; add an attribute to a block
(rload "addtext" '("addtext"))   ; add text below an existing entity
(rload "ano"     '("ano"))       ; kill excess annotation scales
;(rload "asc"     '("asc"))      ; import an ascii art file
(rload "atcase"  '("atcase"))    ; change attr. prompt strings to lower case
(rload "ato"     '("ato"))       ; order a grid of attributes for blocking
(rload "attinc"  '("attinc"))    ; incr one or all att vals in selected blocks
(rload "axe"     '("axe" "exa")) ; text last/first word add/remove; add a space
(rload "ba"      '("ba"))        ; last letter a/b toggle
(rload "bar"     '("bar"))       ; scale bar inserter
(rload "beaker" '("beaker" "txkill")) ; erase invisible and useless crap
(rload "bean"   '("bean" "beans" "bna" "spa" "aps")) ; sequentially renumber blocks or/and text
(rload "beav"    '("beav"))      ; make a beaver stamp
(rload "bf"      '("bf"))        ; break utility - snap control, first point
(rload "bfg"     '("bfg"))       ; remove big fonts from text styles
(rload "bic"     '("bic"))       ; insert lights by rows and columns
(rload "bindo"   '("bindo" "bindx" "bindt")) ; bind/explode xrefs, don't/ditch layers
(rload "bingo"   '("bingo"))     ; rotate text 180 around centre point
;(rload "bisk"   '("bisk"))      ; remove a block from other blocks
(rload "bk"      '("bk"))        ; draw a break line
(rload "bl"      '("bl"))        ; make two lines/plines/arcs into a box
(rload "black"   '("black"))     ; colour everything in the drawing white
(rload "blam"    '("blam"))      ; explode a block, replace atts with text
(rload "bldg"    '("bldg"))      ; make a cut-and-fold building
(rload "blex"    '("blex"))      ; explode all blocks and sub-blocks
(rload "bliz"    '("bliz"))      ; mark everything with snowflakes
(rload "blockout" '("blockout")) ; wblock all blocks in a drawing
(rload "blora" '("blora" "blor")); vertically reshuffle block insertions
(rload "blunt"   '("blunt"))     ; update all of one block, no options
(rload "blur"    '("blur"))      ; replace all inserts of a block w. another
(rload "blurss"  '("blurss"))    ; block replace, only selected blocks
(rload "bn"      '("bn"))        ; reposition text above or below a line
(rload "boo"     '("boo"))       ; zoom previous, mark original view
(rload "boch"    '("boch"))      ; search and replace Bom tag numbers
(rload "bock"    '("bock"))      ; cloud text and/or attributes in blocks
(rload "bolt" '("bolt" "salt" "blot" "blit")) ; make lightning bolts
(rload "bomb"    '("bomb"))      ; rotate text/atts 180 round common centre
(rload "bomex"   '("bomex"))     ; extract Bom tags to a file
(rload "bomin"   '("bomin"))     ; suck a csv into Bom table blocks
(rload "bomp"    '("bomp"))      ; total Bom tag counts
(rload "bounce"  '("bounce"))    ; purge a drawing down to the bare metal
(rload "boxer"   '("boxer"))     ; put ascii boxes around code comments
(rload "bp"      '("bp"))        ; bind permalta if it is an xref
(rload "brac"   '("brac" "brc")) ; draw a bracket: half outline/baseline & dir
(rload "bracket" '("bracket"))   ; draw a bracket on the end of two lines
(rload "brat"    '("brat"))      ; derotate attributes in all of one block
(rload "brot"    '("brot"))      ; rotate all of one block type 180
(rload "bsa"     '("bsa"))       ; beaker, splurge, audit
(rload "btray"   '("btray"))     ; draw and hatch a straight tray section
(rload "bubba"   '("bubba"))     ; toggle an attribute c/m and up/down
(rload "bullet"  '("bullet"))    ; suck data from all of one block to a .cdf
 ; Ŀ
 ;   Bungee saves layer settings to an internal list and a data file,      
 ;   Splash restores them from the list and Flash restores them from the   
 ;   external data file.                                                   
 ; 
(rload "bungee"  '("bungee" "splash" "flash" "flasho" "layup"))
 ; Ŀ
 ;   Box has been renamed to Bx so as to avoid conflict with the           
 ;   internal Acad command.  Bmx is the same but scales by 25.4.           
 ; 
(rload "bx"      '("bx" "bmx"))  ; draw a box, allows drag or measurements
(rload "c"       '("c" "ni" "since")) ; enhanced copy, previous ss finder
(rload "ca"      '("ca"))        ; continue an existing arc, either direction
(rload "cable"   '("cable"))     ; import a .csv into a cable schedule
(rload "candy"   '("candy"))     ; suck any .csv into any blocks
(rload "cat"     '("cat"))       ; convert loose attdefs to text
(rload "cbom"    '("cbom"))      ; BOM import
(rload "centre"  '("centre"))    ; centre justify a text entity
(rload "cf"      '("cf"))        ; vertically rearrange text in a box
(rload "cdat"    '("cdat"))      ; update existing blocks from a .csv file
(rload "chall"   '("chall"))     ; text search and replace for drawings
(rload "chalm"   '("chalm"))     ; text search and replace for drawings, block subents
(rload "chart"   '("chart"))     ; make a chart from a text file
(rload "chat"    '("chat"))      ; explode and reblock an insert
(rload "chg"     '("chg"))       ; directly modify entity data
(rload "chgtext" '("chgtext"))   ; everybody's favourite
(rload "chgx"    '("chgx"))      ; directly modify entity and subentity data
(rload "clk"     '("clk"))       ; simple clock maker
(rload "cls"     '("cls"))       ; like Dos
(rload "cm" '("cb" "cbn" "cm" "cmr" "cn" "cs" "cx")) ; cloud makers
(rload "cma"     '("cma"))       ; flatter cloud maker
(rload "curl"    '("curl"))      ; move entities to current layer
(rload "coil"    '("coil"))      ; coil and tape block/text inserter
(rload "collay"  '("collay"))    ; find entities not coloured bylayer
(rload "cols"    '("cols"))      ; change entities to colour of selected one
(rload "cr"      '("cr"))        ; circle repair - make an arc into a circle
(rload "crab"    '("crab"))      ; realign a line and two blocks
(rload "crypt"   '("crypt"))     ; encryptor
(rload "csv"     '("csv"))       ; import csv/cdf into loose text entities
(rload "curl"    '("curl"))      ; move entities to the current layer
(rload "cw"      '("cw"))        ; rewidth cloud polylines
(rload "cyl"     '("cyl"))       ; 2D cylinder maker
(rload "dart"    '("dart"))      ; derotate all of one type of block
(rload "dasho"   '("dasho"))     ; change 2010.09.09 to 10/09/09 in a whole drawing
;(rload "daub"    '("daub"))     ; make a lisp to copy dimvars from dwg to dwg
(rload "dc"      '("dc"))        ; dcl (dialogue box) file editor
(rload "ddd"     '("ddd" "dddd")); swap empty att. values with "..."
(rload "ddx"     '("ddx"))       ; select text/attdef, use matching editor
(rload "dent"    '("dent"))      ; search and replace block/attr. prompts
(rload "deep"    '("deep"))      ; direct text edit with dialog box
(rload "derot"   '("derot"))     ; derotate - doesn't work on circles
;(rload "descale" '("descale"))   ; descale a drawing
(rload "detitle" '("detitle"))   ; insert a detail tag
(rload "df" '("df" "hump-de-fridge")) ; un-fixed-position attributes
(rload "dg"      '("dg"))        ; destroy all groups containing an entity
 ; Ŀ
 ;   Diaper: search & replace layer names.                                 
 ;   Lance: convert all layer names to upper/lowercase.                    
 ; 
(rload "diaper"  '("diaper" "lance"))
(rload "dif"     '("dif" "tl"))  ; measure distances, running total, temp lines
(rload "dimf"    '("dimf"))      ; restore the default text in a dimension
(rload "dimp"    '("dimp"))      ; change dimension leg endpoints
(rload "dm"      '("dm"))        ; remove a mask from text, kill the group
(rload "dn"      '("dn"))        ; show nesting for a block
(rload "dna"     '("dna"))       ; show nesting for all blocks
(rload "dogbite" '("dogbite"))   ; chop around a circular block
(rload "doglite" '("doglite"))   ; chop around a light block
(rload "doon"    '("doon"))      ; install a conduit down symbol
(rload "door"    '("door"))      ; install a door
(rload "drawlist" '("drawlist")) ; suck a .csv file into a drawing list dwg
(rload "dread"   '("dread" "mf")); erase/fix the _Redline_ layer
(rload "dtr"     '("dtr"))       ; make stacks of blocks (mostly terminals)
(rload "du"      '("du"))        ; write a block updater lisp
 ; Ŀ
 ;   Dsc (schematic): set dimscale, ltscale to 10x that, and snap to 2.5x. 
 ;   Dsl (layout): set dimscale, ltscale to 10x that, and snap to 1x.      
 ; 
(rload "dsc"     '("dsc" "dsl")) ; dimscale/ltscale/snap set
(rload "duck"    '("duck"))      ; erase duplicate superimposed text
(rload "duh"     '("duh"))       ; erase anything not in or crossing a box
(rload "dul"     '("dul" "ul"))  ; remove or add underlining
(rload "dupe"    '("dupe"))      ; find duplicate text strings
(rload "dx"      '("dx"))        ; remove overrides from dimensions
(rload "earth"   '("earth"))     ; draw an earth sized circle
(rload "ecen"    '("ecen"))      ; horizontally centre an ss of entities
;(rload "emu"     '("emu"))      ; write a lisp to make selected entities
(rload "eno"     '("eno"))       ; text to incr. numbers with pre & suffix
(rload "end"     '("end"))       ; replaces the discontinued command
(rload "elsp"    '("elsp"))      ; spiral: ellipt./circ., straight/expon.
(rload "epi"     '("epi"))       ; epicycle generator
(rload "exget"   '("exget"))     ; get extended entity data, other utils
(rload "extro"   '("extro"))     ; extract selected text to a file
(rload "ezlay"   '("ezlay"))     ; same as Reptile, see below
(rload "ezo"     '("ezo"))       ; move block subentities to layer 0
(rload "fand"    '("fand"))      ; text search - see also chall
(rload "fang" '("fang" "fangs")) ; vampiric script file write and run
(rload "fbt"     '("fbt"))       ; find text and blocks which are upside down
(rload "ff"      '("ff"))        ; draw cable lines and breaks
(rload "fibl"    '("fibl"))      ; find block by name or all blocks
(rload "filo"    '("filo"))      ; write ent. data to a file - see also Lox
(rload "filk"    '("filk"))      ; search & replace the last char in ss
(rload "filthy"  '("filthy"))    ; mark insertions of any or all entities
(rload "ffind"   '("ffind"))     ; find files in the acad search path
(rload "fint"    '("fint"))      ; find entities by insertion point
(rload "fifty"   '("fifty"))     ; increment line numbers etc. - whole dwg.
(rload "firk"    '("firk"))      ; search & replace the first char in ss
(rload "fist"    '("fist"))      ; list styles, font files, block fonts etc.
(rload "fixwit"  '("fixwit"))    ; find and optionally fix overly-wide text
(rload "fl"      '("fl"))        ; flip layer state off/frozen to on, vice versa
(rload "flame"   '("flame"))     ; select layers, freeze others, or thaw all
(rload "flat"    '("flat"))      ; remove elevation from entities
(rload "flay"    '("flay"))      ; freeze all layers except the selected one
(rload "flip"    '("flip"))      ; flip single/double sided wire tag
(rload "flood"   '("flood"))     ; floodlight maker
(rload "fluke"   '("fluke"))     ; chop around text/attributes
 ; Ŀ
 ;   Attribute name & position utilities.                                  
 ;   These are zero based - the first number is zero, not one.             
 ; Ĵ
 ;   Foap   Find the zero based position of an attribute in a block.      
 ;   Acho   Temporarily replace attribute values with attribute tags.     
 ;   Defa   Replace attribute values with the defaults.                   
 ;   Fap    Replace attribute values with sequential numbers.             
 ;   Faap   Append sequential numbers to all attribute values.            
 ;   Xae    Empty all attributes in selected blocks.                      
 ;   Xa-    Replace all attribute values in selected blocks with "-"      
 ;   Xad    Replace all attribute values in selected blocks with "..."    
 ;   Xat    Replace all attribute values in selected blocks with "XX".    
 ; 
(rload "foap"    '("acho" "defa" "fap" "fapp" "foap" "xa-" "xae" "xad" "xat"))
 ; Ŀ
 ;   Bring stuff to the front - mostly for wipeout use.                    
 ;   (Which assumes that the wipeout is grouped with the entity.)          
 ; Ĵ
 ;   Front   Move selected entities to the front.                         
 ;   Back    Move selected entities to the back.                          
 ;   Fra     Move a selected entity to the front using the copy method.   
 ;   Fronts  Move a selected entity to the front.                         
 ;   Frob    Move block inserts to the front.                             
 ;   Froh    Move everything but hatches to the front.                    
 ;   Fhit    Move all wipeouts to the front, then text.                   
 ;   Fhor    Move all hatches to the back.                                
 ;   Frot    Move text (optionally all text) to the front.                
 ; 
(rload "front"   '("back" "fra" "front" "fronts" "frob" "froh" "fhit" "fhor" "frot"))
(rload "ftb"     '("ftb"))       ; load toolbars if you have lost them all
(rload "fungus"   '("fungus"))    ; xref repath, batchable, needs editing for setup
(rload "fx"      '("fx" "em"))   ; force join plines etc., em = show vertices
(rload "gc"      '("ga" "gc"))   ; install a ground arc or line
(rload "get"    '("get" "getx")) ; get entity data listing
(rload "gepta"   '("gepta"))     ; insert a terminal block, save ins point
(rload "getq"    '("getq"))      ; extract variables from a routine
(rload "gnd"     '("gnd"))       ; put a ground grid around a building
(rload "gostak"  '("gostak" "goo")) ; suck a stack of text into text or blocks
(rload "gouge"   '("gouge"))     ; extract block subentity data
(rload "gox"     '("gox"))       ; open an xref - sets SDI to 0
(rload "gr"      '("gr"))        ; find groups to which an entity belongs
(rload "grak"    '("grak"))      ; explode all groups
 ; Ŀ
 ;   Grayat - Recolour blocks and attributes.                              
 ; Ĵ
 ;   Grayat - colour all attributes belonging to a given insert gray (8).  
 ;   Gray, colour entities and attributes gray.                                  
 ;   A2, colour entities and attributes 252.                               
 ;   A3, colour entities and attributes 253.                               
 ;   A4, colour entities and attributes 254.                               
 ;   Gash, mark gray attributes and the entities which contain them.       
 ;   Gsh, mark gray entities.                                              
 ;   Oc, colour entities and attributes back to bylayer.                   
 ; 
(rload "grayat"  '("grayat" "gray" "oc" "gsh" "gash" "a2" "a3" "a4"))
(rload "gremp"   '("gremp"))     ; destroy all empty groups
(rload "grim"    '("grim"))      ; draw a grid of boxes
 ; Ŀ
 ;   Grl: make the layer of a selected entity or subentity grey (8).       
 ;   251, 252, 253, 254: make the layer of a selected entity or            
 ;   subentity that colour.  (these are screened 90%, 75%, 50% and 25%     
 ;   in Rocket.ctb, and must be in other ctb files for this to work.)      
 ;   Nop sets a layer to not plot, Pon sets it to plot.                    
 ;   Colours mostly match the standard wire colour names.                  
 ;   None of these will change layer 0, which is the point.                
 ; 
(rload "grl"     '("grl" "249" "250" "251" "252" "253" "254" "nop" "pon"
                   "red" "yel" "grn" "cyan" "blu" "mag" "wht"))
(rload "ground"  '("ground"))    ; insert a ground symbol, ideally on a line
(rload "grpid"   '("grpid"))     ; count, highlight and list all groups
(rload "gyc"     '("gyc" "gy"))  ; centre selected entities in a box
(rload "hang"    '("hang"))      ; beaver and permit stamp killer
 ; Ŀ
 ;   Hatch installers (entity selection):     Aliased to:                 
 ;   Hexhch: Zone 0 hatch installer.          Z0                          
 ;   Xhatch: Zone 1.                          Z1                          
 ;   Slatch: Zone 2.                          Z2                          
 ;   Thatch: Tray hatch.                      Ct                          
 ; 
(rload "hatch"   '("slatch" "xhatch" "thatch" "hexhch"))
(rload "hd"      '("hd"))        ; disassociate a hatch
(rload "hl"      '("hl" "yl" "trl")) ; hatch, yellow, or tray last entity
(rload "hose"    '("hose"))      ; replace solids with hatches
(rload "hoss"    '("hoss"))      ; make an index drawing of a dir of dwgs
(rload "ht"      '("ht"))        ; change selected text height
(rload "hvb" '("hvb" "hm" "hml" "hmr")) ; move/rejustify text on a horiz line
(rload "idle"    '("idle"))      ; remove all rev clouds and blocks
(rload "igloo"   '("igloo"))     ; draw a line in mspace from points in ps
(rload "il"      '("il"))        ; draw isometric lines with fillets
 ; Ŀ
 ;   Inc: increment the first number in a selected text string.            
 ;   Ink: increment all numbers in all selected text strings and blocks.   
 ;   Linc: increment the last number in a selected text string.            
 ;   Dec: decrement the first number in a selected text string.            
 ;   Dek: decrement all numbers in all selected text strings and blocks.   
 ;   Ldec: decrement the last number in a selected text string.            
 ; 
(rload "inc"     '("inc" "ink" "dec" "dek" "linc" "ldec"))
(rload "incend"  '("incend"))    ; insert a block on the end of a line/pline
(rload "inf"     '("inf"))       ; print useful information about the dwg
(rload "ins"     '("ins"))       ; simple insulation maker
(rload "insu"    '("insu"))      ; insulation maker
(rload "intbreak" '("intbreak" "ib")) ; break a line at two intersections
(rload "irg"     '("irg"))       ; regen one or more entities or screen
(rload "j"       '("j"))         ; join lines/plines into one pline
(rload "jumper"  '("jumper"))    ; install a jumper on terminal blocks
(rload "junc"    '("junc"))      ; make a junction box
(rload "kibl"    '("kibl"))      ; erase all insertions of one block type
(rload "klat"    '("klat"))      ; turn off a selected attribute
(rload "klob"    '("klob"))      ; erase overlap in 2 sets of cabletags
(rload "klim"    '("klim"))      ; remove all images from the drawing
(rload "ladd"    '("ladd"))      ; make two lines of text into one
(rload "lake"    '("lake"))      ; erase only things from a selected layer
(rload "lash"    '("lash"))      ; swap pline linetype gen: vertices/overall
(rload "lcb"     '("lcb"))       ; change layer, ltype and colour bylayer
(rload "lch"     '("lch"))       ; change layer by example/name input
(rload "ldr"     '("ldr"))       ; load and run a lisp
(rload "lea"     '("lea" "larn")); layer name case adjusters
(rload "leda"    '("leda" "l3da")) ; non-associative leader, 2.5mm; 3mm
(rload "left"    '("left"))      ; left justify a text entity
(rload "lent"    '("lent"))      ; read a line from a .csv into a block
(rload "lf"      '("lf"))        ; find stuff in a given linetype
(rload "lin"     '("lin"))       ; linetype edit utility
;(rload "linc"    '("linc" "ldec")) ; inc/decrement the final number in a string
(rload "lineup"  '("lineup"))    ; make sure lines with text are upright
(rload "lix"     '("lix"))       ; set limits to extents
(rload "lld"     '("lld"))       ; lisp loader with dialog box
(rload "lldr"    '("lldr"))      ; lisp load and run with dialog box
(rload "lms"     '("lms"))       ; move stuff to a layer, make it current
;(rload "locs"    '("locs"))     ; convert a text file to lowercase with leading caps
(rload "look"    '("look"))      ; trim everything out of a rectangular area
(rload "lox"     '("lox"))       ; write assoc groups from ss to a file
(rload "lsc"     '("lsc" "lsn")) ; adjust entity ltscale; set to bylayer
(rload "lset"    '("lset"))      ; set layer to that of a selected entity
(rload "lsl"     '("lsl"))       ; select stuff on a layer
(rload "lt"      '("lt"))        ; change linetype to match another entity
(rload "ltl"     '("ltl"))       ; reload all linetypes from acad.lin
(rload "ltr"     '("ltr"))       ; dump text to a file from the command line
(rload "lump"    '("lump"))      ; move contents of one layer onto another
(rload "lx"      '("lx"))        ; pull an attribute out of a block
(rload "lwpl"    '("lwpl"))      ; convert plines in blocks to lwplines
(rload "lwt"     '("lwt" "ln"))  ; adjust entity lineweight; set to bylayer
(rload "lxx"     '("lxx"))       ; like xx - editor load with dialog box
(rload "mach"    '("mach"))      ; attribute search/replace - with windowing
(rload "mada"    '("mada"))      ; erase only entities from redline layers
(rload "mama"    '("mama"))      ; individually mask multiple text entities
(rload "map"     '("map"))       ; file editor load - like xx, narrower cols
(rload "marmot"  '("marmot"))    ; multi-attribute squash
(rload "mash"    '("mash"))      ; multi-attribute replace with windowing
(rload "mattress"'("mattress"))  ; align text with matchlines, pw, lt, layer
(rload "mer"     '("mec" "mel" "mer")) ; attribute rejustify: c, ml, mr
(rload "melon"   '("melon" "si")); imperial to metric utilities
(rload "mex"     '("mex"))       ; explode all mtext
(rload "middle"  '("middle"))    ; middle justify a text entity
(rload "min"     '("min"))       ; minsert editor
(rload "miss"    '("miss"))      ; a more interesting explode command
(rload "mmm"     '("mmm"))       ; make text into mtext - a dubious ability
(rload "mmi"     '("mmi"))       ; mirror with text justification mirroring
(rload "mn"      '("mn"))        ; reload the current menu
(rload "mnx"     '("mnx" "omno")); load/unload the Rocket partial menu
(rload "mold"    '("mold"))      ; mark every entity in the drawing...
(rload "moo"     '("moo"))       ; partial (pop 16) menu loader
(rload "moss"    '("moss"))      ; suck entities from model into paper space
(rload "moz" '("mox" "moy" "moz")) ; move stuff x, y and z by partial coord sleection
(rload "mp"      '("mp"))        ; match props - layer, colour, and linetype
(rload "muddle"  '("muddle"))    ; convert text/attdefs to middle justified
(rload "mull"    '("mull"))      ; reorder cable tags by type (attributes)
(rload "mullet"  '("mullet"))    ; reorder cable tags by type (text)
(rload "mva" '("mva" "mvi" "mvo")) ; move lower left of dwg to 0,0 (or ss: mvo)
(rload "mx"      '("mx"))        ; edit the current menu file - obsolete?
(rload "n"       '("n"))         ; list entity information, no flipscreen
(rload "naff"    '("naff"))      ; crush attributes to fit unknown tag blocks
(rload "naf"     '("naf"))       ; naff with more elaborate graphics
(rload "nail"    '("nail"))      ; make Notes text
(rload "nch"     '("nch"))       ; directly change entity/subentity
(rload "nepo"    '("nepo"))      ; a strange point connector
(rload "next"    '("next" "nex")); go to the next dwg in the dir, save/don't
(rload "nn"      '("nn"))        ; list subentity information, no flipscreen
(rload "np"      '("np" "bap"))  ; plot utility
(rload "nt"      '("nt"))        ; incremented numbers with optional text
(rload "numf"    '("numf"))      ; write series of numbers to a file
(rload "nxlay"   '("nxlay"))     ; go to the next layer, freeze all others
(rload "obl"     '("obl" "obx")) ; kill/explode all inserts of any blocks in an ss
(rload "ofc"     '("ofc"))       ; 2D sphere maker
(rload "oshad"   '("oshad"))     ; change 10/09/09 to 2010.09.09 in a whole drawing
 ; Ŀ
 ;   Pac - suck two lines of text, put into one.                           
 ;   Cap - suck one line of text, split, put into two.                     
 ;   Jef - suck a device tag, add -1, -2, etc., put into wire tags.        
 ; 
(rload "pac"     '("pac" "cap" "jef"))
(rload "pang"    '("pang"))      ; screen shaker
(rload "panic"   '("panic"))     ; distribution panel maker
(rload "parabola" '("parabola")) ; draw a parabola with light rays
(rload "pc"      '("pc"))        ; draw a circle in ps over one in ms
(rload "pcl"     '("pcl"))       ; close a polyline
(rload "penguin" '("penguin"))   ; multiple line/polyline intersec breaker
(rload "pfp"     '("pfp"))       ; full screen text editor
(rload "pga"     '("pga"))       ; another tag inserter - see Tga
(rload "phd"     '("phd"))       ; remove big font text styles
(rload "phdel"   '("phdel"))     ; delete all frozen layers
(rload "pid"     '("pid"))       ; add pre/suffix to text
(rload "pit"     '("pit"))       ; rotate text into the next isoplane
(rload "pivot"   '("pivot"))     ; rotate text & atts into the next isoplane
(rload "pj"      '("pj"))        ; join two noncontinuous polylines
(rload "pkill"   '("pkill"))     ; erase all points
(rload "pollar"  '("pollar" "pol" "polo")) ; brushstroke exisitng pline clouds
(rload "pong"    '("pong"))      ; pong
(rload "play"    '("play"))      ; see why you can't purge an empty layer
(rload "plim"    '("plim"))      ; reset target and camera points
(rload "pog"     '("pog" "pag")) ; ground line or arc with end blocks as 1 ent
 ; Ŀ
 ;   Pulp - make selected blocks auto-updating.  The update is done by     
 ;   C:Blup which is loaded and run automatically.  Note that this         
 ;   doesn't duplicate xrefs - it is a better approach.                    
 ; 
(rload "pulp"    '("blix" "pulp" "dpulp" "epulp" "hpulp"))
(rload "punk"    '("punk"))      ; insert multiple blocks, increment, break
(rload "pur"     '("pur"))       ; repostion leaders/blocks/lines/circles
(rload "pw"      '("pw"))        ; rewidth a polyline to half of dimscale
(rload "pxx"     '("pxx"))       ; explode all polylines and lwpolylines
(rload "qeb"     '("qeb"))       ; wblock an existing block
(rload "rain"    '("rain"))      ; rain
(rload "raj"     '("raj"))       ; suck superimposed text into a block
(rload "raja"    '("raja"))      ; suck superimposed text into many blocks
(rload "ral"     '("ral" "lar")) ; rotate/derotate a drawing 90 degrees
 ; Ŀ
 ;   Rash - update rev triangles to match the tb.                          
 ;   Rt - insert a rev block with the right rev as the default.            
 ; 
(rload "rash"    '("rash" "rt"))
(rload "rat"     '("rat"))       ; make text into an attdef
(rload "ratt"    '("ratt"))      ; fast ss of text to attdefs converter
(rload "reco"    '("reco"))      ; recolour n/(n+1) entities in order
(rload "rel"     '("rel"))       ; make loose lines and arrows into a leader
(rload "repall"  '("repall"))    ; text search & replace for batch files
(rload "mepall"  '("mepall"))    ; text & block etc search & replace for batch files
(rload "repo"    '("repo"))      ; reinsert one or all available blocks
(rload "reptile" '("reptile"))   ; cold blooded layer rehasher
(rload "reset"   '("reset"))     ; reset common problem system variables
(rload "right"   '("right"))     ; right justify a text entity
(rload "rl"      '("rl"))        ; relayer with subentities
(rload "rocket"  '("rocket"))    ; reformat text for Rocket.shx
 ; Ŀ
 ;   Rx - rotate 5 degrees around the X axis.                              
 ;   Xrr - rotate backwards 5 degrees around the X axis.                   
 ;   Ry - rotate 5 degrees around the Y axis.                              
 ;   Yr - rotate backwards 5 degrees around the Y axis.                    
 ;   Rz - rotate 5 degrees around the Z axis.                              
 ;   Zr - rotate backwards 5 degrees around the Z axis.                    
 ; 
(rload "rx"     '("rx" "xrr" "ry" "yr" "rz" "zr"))
(rload "scabl" '("scabl" "prop" "p1")); rescale blocks, scale to dimscale, to 1
(rload "sch"     '("sch"))       ; restyle text
(rload "scream"  '("scream"))    ; replace one att in a number of blocks
(rload "scrub"   '("scrub"))     ; chgtext for multiple blocks
(rload "sd"      '("sd"))        ; i/o schematic text extractor for s/d keys
(rload "sdel"    '("sdel"))      ; delete one type of entity from selected
(rload "sec"     '("sec"))       ; section arrow maker
(rload "sev" '("sev" "ves" "vesf")) ; save sysvars, see changes
(rload "shag"    '("shag"))      ; find shapes as entities & subentities
(rload "shield"  '("shield"))    ; install a shield on jb wires
(rload "shark"   '("shark"))     ; kill entities under a certain size
;(rload "shift"  '("shift"))     ; search & replace with goto & confirm
(rload "shuffle" '("shuffle"))   ; vertically arrange text between two points
(rload "shutdown"'("shutdown"))  ; import an excel file into a shutdown key
(rload "sklork"  '("sklork"))    ; vert. alphabetize att vals between blocks
(rload "snake"   '("snake"))     ; put entities on snap
(rload "sname"   '("sname"))     ; put the drawing name in the screen menu
(rload "snatch"  '("snatch"))    ; install an iso penetration symbol
(rload "sort"    '("sort"))      ; export loose text into a csv by position
(rload "snat"    '("snat"))      ; toggle snap dimscale - 2.5 x dimscale
(rload "snatch"  '("snatch"))    ; make an isometric penetration symbol
(rload "snort"   '("snort"))     ; export loose text into a csv by location
(rload "spam"    '("spam"))      ; suck entities from paper into model space
(rload "span"    '("span"))      ; pan in mspace based on points in pspace
(rload "spk" '("spc" "spk" "spak")); kill start, end, extra spaces, text/blocks
(rload "splurge" '("splurge"))   ; automatic purge to completion
(rload "spor"    '("spor"))      ; spiral array maker
(rload "spyr"    '("spyr"))      ; pattern maker
(rload "squid"   '("squid"))     ; squash shutdown atts to fit in cells
(rload "squish"  '("squish"))    ; squash text to no more than desired width
(rload "squab"   '("squab"))     ; rewidth attributes in a variety of blocks
(rload "ssq"     '("ssq"))       ; edit multiple text ents in order by pos
(rload "stand"   '("stand"))     ; standard detail tag installer
(rload "star" '("star" "starr")) ; star makers
(rload "stlay"   '("stlay"))     ; rehash layers
(rload "stoat"   '("stoat"))     ; write all text/atts from dwg to text file
(rload "strafe"  '("strafe"))    ; break text entities at spaces
(rload "styx"    '("styx"))      ; reset standard text styles
(rload "sun"     '("sun"))       ; print subentity data list, direct select
(rload "sundog"  '("sundog"))    ; turn a cloud inside out
(rload "surf"    '("surf"))      ; draw a wipeout, select front entities
(rload "surv"    '("surv"))      ; colour/lt explicitly, move to one layer
(rload "swat"    '("swat"))      ; swap devices open/closed etc. etc.
(rload "switch"  '("switch"))    ; reinsert i/o switch device blocks
(rload "swx"     '("swx"))       ; swap positions of two sets of entities
(rload "sycomp" '("sysave" "sycomp" "sycompf")) ; save atomlist, see changes
(rload "sz"      '("sz" "sz1"))  ; reduce or set to 1 the width of text or att
(rload "t"       '("t"))         ; trim with snap control
(rload "t3"      '("t3"))        ; split a text line into a stack
;(rload "tafi"   '("tafi"))      ; find blocks with given attr. strings
(rload "tater"   '("tater"))     ; change text even if it's in a block
(rload "tar"     '("tar" "tal")) ; center or left rejustify multiple text in boxes
(rload "tarc"    '("tarc"))      ; move a circle to be tangent to two others
(rload "tara"    '("tara"))      ; rearrange text to fit in a box - for i/o
 ; Ŀ
 ;   Tb - switch tag blocks for ones with breaks for oversized text.       
 ;   Bt - replace all chopped blocks with the unchopped version.           
 ;   Twa - set all attributes in a block to 0.9 width.                     
 ; 
(rload "tb"      '("tb" "bt" "twa"))
(rload "tbone"   '("tbone"))     ; fillet lines without trimming
(rload "tch"     '("tch"))       ; replace multiple text strings
(rload "tea"     '("tea" "trot")); centre text in a box
(rload "teal"    '("teal"))      ; left justify and align text in a box
(rload "tear"    '("tear"))      ; right justify and align text in a box
(rload "tech"    '("tech"))      ; chgtext for text, atts, attdefs, etc.
(rload "term"    '("term"))      ; put an arrowhead on a line
(rload "tess"    '("tess"))      ; tesseract (4D cube in 3D) maker
(rload "texas"   '("texas"))     ; multiple text/attr/etc. change
(rload "tga"     '("tga" "tg"))  ; draw a polyline and insert cable tag blocks
(rload "tic"     '("tic"))       ; reposition any text in selected circles
(rload "tiger"   '("tiger"))     ; rejoin lines if they are colinear
(rload "tk"      '("tk"))        ; suck text, destroy source
(rload "tlen"    '("tlen"))      ; measure heat trace lines
(rload "tmx"     '("tmx"))       ; align wiring with terminals
(rload "tork"    '("tork"))      ; derotate multi text around common centre
(rload "tota"    '("tota"))      ; total all numbers in text strings and blocks
(rload "tray"    '("tray"))      ; draw a tray bend
 ; Ŀ
 ;   Hatch installers (point selection):     Aliased to:                   
 ;   Bhex: Zone 0 hatch installer.           B0                            
 ;   Ansi131: Zone 1.                        B1                            
 ;   Ansi137: Zone 2.                        B2                            
 ;   Bct: Tray hatch.                        Bct                           
 ; 
(rload "trayhach" '("bhex" "ansi31" "ansi37" "trayhach"))
(rload "trg"     '("trg"))       ; ground cable tray
(rload "trouble" '("trouble"))   ; diagnostic information
(rload "trx"     '("trx"))       ; draw a vertical tray section
(rload "ts"      '("ts"))        ; draw 35mm rail between terminals
(rload "tswap"   '("tswap"))     ; swap two text entities
(rload "ttb"     '("ttb"))       ; suck grid text into blocks
(rload "tv"      '("tv"))        ; centre text in a box, fix line spacing
(rload "twod"    '("twod"))      ; erase everything which isn't a 3dsolid
(rload "twip"    '("twip"))      ; draw a twisted pair cable
(rload "txkill"  '("txkill"))    ; kill empty text strings
(rload "txs"     '("txs"))       ; selective global text height change
 ; Ŀ
 ;   Text to standard string changers.                                      
 ; Ĵ
 ;   Txtt     Text To Title (without path).                                
 ;   -        Text To "-".                                                 
 ;   20       Text To "#2/0 GND".                                          
 ;   40       Text To "#4/0 GND".                                          
 ;   2G       Text To "#2 GND".                                            
 ;   Asr      Text to "A/R".                                               
 ;   Asb      Text to "As-Built Per Field Markups".                        
 ;   Barr     Text to "Barrier".                                           
 ;   Cod      Text To "Continued on Dwg.".                                 
 ;   Coda     Text To "Continued on Dwg. (current dwg name)"               
 ;   Ea       Empty an attribute.                                          
 ;   Future   Text To "Future".                                            
 ;   Hold     Text To "Hold".                                              
 ;   Ifc      Text To "Issued For Construction".                           
 ;   Note     Text To "NOTE 1".                                            
 ;   N1       Text To "NOTE 1".                                            
 ;   N2       Text To "NOTE 2".                                            
 ;   N3       Text To "NOTE 3".                                            
 ;   Nts      Text To "NTS".                                               
 ;   Part     Text To "Part Of".                                           
 ;   Scal     Text to 1 : drawing scale.                                   
 ;   Spare    Text to "Spare" or "Spare n", depending.                     
 ;   Txd      Text To date in short year format: 01.01.01.                 
 ;   Txdd     Text To date in long year format: 2008.03.12.                
 ;   Txpp     Text To Title with path.                                     
 ; 
(rload "txtt"  '("-" "20" "40" "2g" "asr" "asb" "barr" "cod" "coda" "ea" "future"
                 "hold" "ifc" "note" "n1" "n2" "n3" "nts" "part" "scal" "spare"
                 "txd" "txdd" "txpp" "txtt"))
(rload "twip"    '("twip"))      ; draw twisted pair conductors
(rload "typ"     '("typ"))       ; swap the Typ. tag from side to side
 ; Ŀ
 ;   Uct: uppercase a single text line or attribute.                       
 ;   Lc: lowercase a single text line or attribute.                        
 ;   Ic: initial capitalise single text line or attribute.                 
 ;   Uc: uppercase all selected text and attributes in selected blocks.    
 ;   Fcase: initial capitalise all selected text.                          
 ; 
(rload "uc"      '("uc" "uct" "ic" "lc" "fcase"))
(rload "upright" '("upright"))   ; *** rotate text which is at a bad angle
(rload "us"      '("us"))        ; cycle through superimposed entities
(rload "uv"      '("uv"))        ; uv=display user sysvars, kuv=empty them
(rload "vb"      '("vb"))        ; multiple text fit rejustify
(rload "vbc"     '("vbc"))       ; multiple text centre rejustify
(rload "vbl"     '("vbl"))       ; multiple text left rejustify
 ; Ŀ
 ;   Vbox: draw a box in ms matching a vport in ps.                        
 ;   Cord: add ms coordinates to ps viewport area limit text.              
 ;   Card: add ms coordinates to ps viewport matchline text.               
 ; 
(rload "vbox"    '("vbox" "cord" "card"))
(rload "vbr"     '("vbr"))       ; multiple text right rejustify
(rload "vbml"    '("vbml"))      ; multiple text middle left rejustify
(rload "vbmr"    '("vbmr"))      ; multiple text middle right rejustify
(rload "vbm"     '("vbm"))       ; multiple text middle rejustify
(rload "vess"    '("vess"))      ; vessel maker
(rload "vino"    '("vino"))      ; incremental vertical attribute renumber
(rload "vis"     '("vis"))       ; turn invisible attributes on
(rload "vl"   '("vl" "vu" "vt")) ; lock/unlock viewports, change twist angle
(rload "vph"     '("vph"))       ; set all vports to 2D hidden
(rload "vvb"     '("vvb" "vvbc")); text line vertical respacer/with justify
;(rload "water"  '("water"))     ; create temporary graphic making lisps
(rload "wir"     '("wir"))       ; jb wiring installer
(rload "wireline" '("wireline")) ; change all line numbers in a block
(rload "wiretag" '("wiretag"))   ; insert a horizontal or vertical wire tag
(rload "wiretagr"'("wiretagr"))  ; insert horiz. or vert. wire tag on right
(rload "wiz"     '("wiz" "wx"))  ; put a wipeout under selected entities
(rload "wm"      '("wm"))        ; move words from one text line to another
(rload "wobble"  '("wobble"))    ; draw wiggly heat trace lines
(rload "wog"     '("wog"))       ; draw wiggly heat trace lines
(rload "wolf"    '("wolf"))      ; join lines if they are ~ colinear
(rload "wormdog" '("wormdog"))   ; move attributes
(rload "wt"   '("wt" "ww" "w8" "w85" "w9")) ; multi text width change, input/example
(rload "xa"      '("xa"))        ; search & replace attdef tags and prompts
(rload "xf"      '("xf" "xup"))  ; toggle xclip/wip frames on/off, update xrefs
(rload "xing"    '("xing"))      ; multiple line intersection breaker
(rload "xl"      '("xl"))        ; extendo-trim
(rload "xnames"  '("xnames"))    ; place/update the xref list block
 ; Ŀ
 ;   Xswitch is obsolete with 2005 and SDI - see Gox.lsp                   
 ; 
(rload "xswitch" '("xswitch" "xback")) ; XSwitch: go to xref, XBack: return
(rload "xx"      '("xx"))        ; file editor load - shares name with ld
(rload "xt"      '("xt"))        ; explode text, or probably anything else
(rload "yalf"    '("yalf"))      ; freeze a layer by entity selection
(rload "yang"    '("yang"))      ; pipe end drawer
(rload "zc"      '("zc"))        ; zoom to the extents of what is onscreen
(rload "ze"      '("ze"))        ; zoom extents without regen
(rload "zeo"     '("zeo"))       ; prepare stuff to block: relayer, colour, etc.
(rload "zing"    '("zing"))      ; multiple directional line intersec break
(rload "zlin"    '("zlin"))      ; polyline pattern drawer
(rload "zp"      '("zp"))        ; zoom previous
(rload "zx"      '("zx"))        ; zoom to extents of what is on screen
(rload "zz"      '("zz"))        ; file editor load - like xx, diff. file
 ; Ŀ
 ;   Calculate elapsed time, print the value.                              
 ; 
(ct1)
